# ==== bombe_poles.py : bombe polonaise en python
# pas de problemes de turnover, version: v2

import sys
import enigmaM3noTurn
import string	
from bib_util import *
import getopt
import random
import time
import signal, os
import re

ALPHA=string.ascii_uppercase
# ===================================
def add_letter( let_x, let_y):
    x = ALPHA.find( let_x )
    y = ALPHA.find( let_y )
    return ALPHA[ (x+y)%26 ]
# ===================================
# ===================================
# ===================================
def dechiffre(msg, e ):
    crypto = ""
    for car in msg:
        crypto += e.encode( car )
    return crypto
# ===================================
# ===================================
# ===================================
def extrait( debut, fin ):
    ch_extrait = ALPHA[ ALPHA.find(debut) : ALPHA.find(fin) + 1 ]
    return ch_extrait
# ===================================
def decode_grund( ch ):
    tb = ch.split(":")
    if len(tb) == 1:
        return (ch[0],ch[1],ch[2])
    gr_l = extrait( tb[0][0], tb[1][0])
    gr_m = extrait( tb[0][1], tb[1][1])
    gr_r = extrait( tb[0][2], tb[1][2])
    return (gr_l, gr_m, gr_r)
# ===================================
def decode_ring( ch ):
    tb = ch.split(":")
    if len(tb) == 1:
        return (ch[0], ch[1], ch[2])
    r_l = extrait( tb[0][0], tb[1][0])
    r_m = extrait( tb[0][1], tb[1][1])
    r_r = extrait( tb[0][2], tb[1][2])
    return (r_l, r_m, r_r)
# ===================================
def sig_handler(signum, frame):
    global last_time
    if time.time() - last_time < 10: sys.exit(0)
    print("[",walhs,RING,GRUND,int(time.time()-start_time)/60, end=' ')
    print(nb_dechif,"]")
    last_time = time.time()
# ===================================
def usage():
    print("usage:")
    print("  -h             Online Help")
    print("  -g FZM,KBQ,MGT The grunds for female (3 or more values)")
    print("  -v             Verbose (mode Debug)")
    print("  -W X,Y,Z       The Walzenlage, example: -W I,II,III")
    print("  -G XXX:ZZZ     The Grund domain. Examples: ")
    print("     -G AAA:ZZZ [by default], -G DGJ, AGA:AGZ, ...")
    print("  -L letter      The Letter (female)")
    print("  -S Letter      The other letter of the stecker (by default the female)")
    print("  -R XXX:ZZZZ     The Ringstellung domain (AAA by default)")
    print("  -U UKW         The Reflector, by default B")
    print("  -s steckers    The Steckers, ex: AH:JQ:LP:EZ:RT:NF, nothing by default")
    print("Ctrl-C prints the progression, two Ctrl-C stops the program")
# ------------------ DEBUT PROGRAMME ---------------------
# ----- on traite les options
try:
    opts, args = getopt.getopt(sys.argv[1:],
        "hvg:W:G:R:s:L:S:U:", ["help", "verbose", "thegrunds=", 
        "walzenlage=", "grund=", "ring=", "steckers=", "letter=", "other=",
        "ukw=" ])
except getopt.GetoptError as err:
    usage()
    sys.exit(2)

DEBUG=False
lesg = []
GRUND_UKW    = string.ascii_uppercase
GRUND_LEFT   = string.ascii_uppercase
GRUND_MIDDLE = string.ascii_uppercase
GRUND_RIGHT  = string.ascii_uppercase
RING_UKW  = string.ascii_uppercase
RING_LEFT = string.ascii_uppercase
RING_MIDDLE = string.ascii_uppercase
RING_RIGHT  = string.ascii_uppercase
WALHENZAGE = "I,II,III"
UKW = 'B' 
STECKERS = ""
RING = 'AAA'
GRUND = 'AAA'
LETTER = 'A'
OTHERL = 'A'

for o, a in opts:
    if o == "-v":
        DEBUG = True
    elif o in ("-h", "--help"):
        usage()
        sys.exit()
    elif o in ("-g", "--thegrunds"):
        lesg = a.split(",")
    elif o in ("-W", "--walzenlage"):
        WALHENZAGE = a
    elif o in ("-G", "--grund"):
        (GRUND_LEFT, GRUND_MIDDLE, GRUND_RIGHT) = decode_grund(a)
    elif o in ("-R", "--ring"):
        (RING_LEFT, RING_MIDDLE, RING_RIGHT) = decode_ring(a)
        RING = RING_LEFT + RING_MIDDLE + RING_RIGHT
    elif o in ("-L", "--letter"):
        LETTER = a 
        OTHERL = a
    elif o in ("-U", "--ukw"):
        UKW = a
    elif o in ("-s", "--steckers"):
        STECKERS = a
    elif o in ("-S", "--other"):
        OTHERL = a
    else:
        assert False, "unhandled option"
if len(lesg) == 0:
    usage()
    sys.exit(1)
# ---------------------------
start_time = time.time() ; last_time = 0
signal.signal(signal.SIGINT, sig_handler)
let4 = LETTER  * 4
for walhs in [WALHENZAGE]:
 tb = walhs.split(",")
 LEFT = tb[0]; MIDDLE = tb[1]; RIGHT = tb[2] 
 if LETTER != OTHERL:
    STECKERS = LETTER + OTHERL
 else:
    STECKERS = LETTER + LETTER
 c = enigmaM3noTurn.Enigma(UKW,LEFT,MIDDLE,RIGHT,STECKERS,RING,GRUND,DEBUG)
 #print "Walhs Ring Grund pln cry - signature cycles grund (left,mid,rig)"
 #print "================================================================"
 for g_l in GRUND_LEFT:
  for g_m in GRUND_MIDDLE:
   for g_r in GRUND_RIGHT:
    GRUND = g_l + g_m + g_r
    stop = True
    lesPos = ""
    for ung in lesg:
        ung_l = ung[0] ; ung_m = ung[1] ; ung_r = ung[2]
        pos = ""
        pos += add_letter( g_l, ung_l )   
        pos += add_letter( g_m, ung_m )   
        pos += add_letter( g_r, ung_r )   
        c.setGrund( pos )
        plain = dechiffre( let4, c )
        if plain[0] == plain[3]:
            lesPos += pos + ","
            continue
        stop = False
        break
    if stop:
        #print(walhs + ':' + RING + ':' + ":" + GRUND + " pos:" + lesPos)
        print('Walzenlage:' + walhs + ' ,Stecker:' + STECKERS + " ,stop:" + lesPos[0:3])

