# enigma.py : modele Enigma M3

import string

def C2L(car):
    return string.ascii_uppercase.index(car)

def L2C(lettre):
    return  string.ascii_uppercase[lettre]

class Rotor:
    def __init__(self,nomDuRotor):
        fic = open("rotors/"+nomDuRotor+".rot","r")
        PI = fic.readline()
        # print "===> ", PI
        les_notchs = fic.readline()
        les_notchs = les_notchs.strip()
        # print "===> ", les_notchs, " lg: ", len(les_notchs)
        self.decal = list(range(26))
        self.decal_inv = list(range(26))
        self.Notchs = list(range(26))
        self.ring = 0
        self.index = 0
        tampon = list(range(26))
        for i in range(26):
            indice = C2L(PI[i])
            self.decal[i] = ( indice - i + 26 ) % 26
        for i in range(26):
            tampon[ C2L( PI[i] ) ] = i
        for i in range(26):
            self.decal_inv[i] = ( tampon[i] - i + 26 ) % 26
        for i in range(26):
            self.Notchs[i] = 0
        for i in range(len(les_notchs)):
            self.Notchs[ C2L( les_notchs[i] ) ] = 1
        #print nomDuRotor
        #print self.decal
        #print self.decal_inv

    def setGrund(self,x):
        self.index = x
    def getGrund(self):
        return self.index
    def isCarry(self):
        if ( self.Notchs[self.index]): 
            return 1
        else: 
            return 0
    def setRing(self, x):
        self.ring = x
    def avance(self):
        self.index = (self.index + 1) % 26
    def recule(self):
        self.index = (self.index - 1 + 26) % 26
    def chiffre(self,x):
        return (x + self.decal[ (x + self.index - self.ring + 26)%26 ]) % 26
    def dechiffre(self,x):
        return (x + self.decal_inv[ (x+ self.index - self.ring + 26)%26 ]) % 26


class Stecker:
    def __init__(self,LesSteckers):
        self.s = list(range(26))
        if len(LesSteckers) == 0:
            return
        Steckers = LesSteckers.split(":")
        # print "====> ", len(Steckers), "===>", LesSteckers, "<==="
        for i in range(len(Steckers)):
            # print "+++", Steckers[i]
            x = C2L( Steckers[i][0] )
            y = C2L( Steckers[i][1] )
            self.s[x] = y
            self.s[y] = x

    def chiffre(self, x):
        return self.s[x]                


class Enigma:
    DoubleStep = 0
    def __init__(self,ukw="B",left="III",middle="II",right="I",stecks="", \
        ring="AAA",grund="AAA", debuging=0):
        self.Debug = debuging
        self.compteur = 0
        self.rotor_right = Rotor(right)
        self.rotor_middle= Rotor(middle)
        self.rotor_left  = Rotor(left)
        self.rotor_reflec= Rotor(ukw)
        self.rotor_right.setGrund(C2L(grund[2]))
        self.rotor_middle.setGrund(C2L(grund[1]))
        self.rotor_left.setGrund(C2L(grund[0]))
        self.rotor_right.setRing(C2L(ring[2]))
        self.rotor_middle.setRing(C2L(ring[1]))
        self.rotor_left.setRing(C2L(ring[0]))
        self.steck = Stecker(stecks)

    def setGrund(self, grund):
        Enigma.DoubleStep = 0
        self.rotor_right.setGrund(C2L(grund[2]))
        self.rotor_middle.setGrund(C2L(grund[1]))
        self.rotor_left.setGrund(C2L(grund[0]))

    def setRing(self, ring):
        self.rotor_right.setRing(C2L(ring[2]))
        self.rotor_middle.setRing(C2L(ring[1]))
        self.rotor_left.setRing(C2L(ring[0]))

    def encode(self,car):
        lettre = C2L(car)
        self.compteur = self.compteur + 1
        # No Turnover !!!
        #if  Enigma.DoubleStep :
        #    self.rotor_left.avance()
        #    self.rotor_middle.avance()
        #    Enigma.DoubleStep = 0
        #if  self.rotor_right.isCarry() :
        #    self.rotor_middle.avance()
        #if  self.rotor_middle.isCarry() :
        #    Enigma.DoubleStep = 1
        self.rotor_right.avance()
        if self.Debug: 
            print("[%04d]" % (self.compteur), end=' ')
            print("=", end=' ')
            print(L2C(self.rotor_left.getGrund()), end=' ') 
            print(L2C(self.rotor_middle.getGrund()), end=' ') 
            print(L2C(self.rotor_right.getGrund()), end=' ') 
            print("=", L2C(lettre), "->", end=' ')
        lettre = self.steck.chiffre(lettre)
        if self.Debug: print(L2C(lettre),":", end=' ')
        lettre = self.rotor_right.chiffre(lettre)
        if self.Debug: print(L2C(lettre), end=' ')
        lettre = self.rotor_middle.chiffre(lettre)
        if self.Debug: print(L2C(lettre), end=' ')
        lettre = self.rotor_left.chiffre(lettre)
        if self.Debug: print(L2C(lettre), "<", end=' ')
        lettre = self.rotor_reflec.chiffre(lettre)
        if self.Debug: print(L2C(lettre), ">", end=' ')
        lettre = self.rotor_left.dechiffre(lettre)
        if self.Debug: print(L2C(lettre), end=' ')
        lettre = self.rotor_middle.dechiffre(lettre)
        if self.Debug: print(L2C(lettre), end=' ')
        lettre = self.rotor_right.dechiffre(lettre)
        if self.Debug: print(L2C(lettre), end=' ')
        lettre = self.steck.chiffre(lettre)
        if self.Debug: print("->", L2C(lettre))
        return L2C(lettre)

    def decode(self,car):
        return encode( self, car)
