# chi2.py
# --- Attaque avec connaissance uniquement du crypto. On suppose connue nb secteurs
# --- On se base sur la méthode de Sacco: on répartie le crypto en 26xLW cases.
#     chaque case contient un alphabet, on fait un Chi2 sur 2 colonnes adjacentes
#     décalées de 0 à 25.
# a faire:

import sys
import string
import getopt

ALPHA = string.ascii_uppercase
# ===================================
def IC( f ):
    N = 0 ; total = 0 ; ic = 0
    for i in range(26):
        #if ( f[i] > 1):
        total = total + f[i]*(f[i]-1)
        N += f[i]
    if N > 1:
        ic =  total / float(N * (N-1))
    return ic
# ===================================
def lecture(nom):
    f = open(nom)
    leTexte = f.readlines()
    txt = ""
    for i in range(len(leTexte)):
        ch = leTexte[i].strip()
        ch = ch.upper()
        for j in range(len(ch)):
            if ch[j] in ALPHA:
                txt += ch[j]
    return txt

#--------------------------------------------------
def ic(tb):
    i1,j1,i2,j2 = tb
    mixte = CASES[i1][j1] + CASES[i2][j2]
    result = 0
    for lettre in ALPHA:
        v = mixte.count(lettre)
        if v >= 1:
            result += v * (v - 1)
    x =  result / (len(mixte) * (len(mixte) - 1))
    return x

#--------------------------------------------------
def chi(tb):
    r2 = 0
    n1 = n2 = 0
    i1,j1,i2,j2 = tb
    for lettre in ALPHA:
        v1 = CASES[i1][j1].count(lettre)
        v2 = CASES[i2][j2].count(lettre)
        n1 += v1
        n2 += v2
        r2 += (v1*v2)
    return r2 / (n1*n2)

# ===================================
def usage():
    print("usage:")
    print("  -h         Help")
    print("  -c crypto	The cryptogram")
    print("  -m maximum LW: number of sectors of the wheels")
    print("  -t value   Next column (+1 by default)")
    print("  -M method  chi2 or ic (chi2 by default)")
    print("  -v         Verbose (debug)")
#--------------------------------------------------
try:
  opts, args = getopt.getopt(sys.argv[1:], 
    "hc:m:t:vM:", ["help", "crypto=", "maximum=", "threshold=", "verbose", "method="])
except getopt.GetoptError as err:
  # print help information and exit:
  print(sys.argv[0],": ", str(err)) # option -a not recognized"
  usage()
  sys.exit(2)

DEBUG = False
msg = ""
SEUIL = 1
MAXIMUM = 500
LW = 17
METHOD = 0
EVAL =  [ chi , ic ]

for o, a in opts:
  if o == "-v":
    DEBUG = True
  elif o in ("-h", "--help"):
    usage()
    sys.exit()
  elif o in ("-c", "--crypto"):
    msg = lecture( a )
  elif o in ("-m", "--maximum"):
    LW = int(a)
  elif o in ("-t", "--threshold"):
    SEUIL = int(a)
  elif o in ("-M", "--method"):
    if a == "chi2":
        METHOD = 0
    elif a == "ic":
        METHOD = 1
  else:
    assert False, "unhandled option"
if msg == "" :
  usage()
  sys.exit(1)
#--------------------------------------------------
# ====== DEBUT DU PROGRAMME =========

# == 1. on cree le tableau LWx26
LG = len(msg)
CASES = []
RHO = []
for i in range(26):
    CASES.append([""]*LW)
    RHO.append([0]*LW)

CRYPTO = msg
#print(CRYPTO)
#print(CASES)

# == 2 - on repartie les lettres
for i in range(len(CRYPTO)):
    idx_i = (i // LW) % 26
    idx_j = i %  LW
    #print(i, idx_i, idx_j)
    CASES[idx_i][idx_j] += CRYPTO[i]

# == 3 - on affiche le tableau
for i in range(26):
    print("%2d: " % (i), end="")
    for j in range(LW):
        print("%-20s" % (CASES[i][j]), end=",")
    print()

# == 4 - on calcule le chi2
for colonne in range(LW):
    for decalage in range(26):
        x = 0
        for ligne in range(26):
            t = list([ligne, colonne, (ligne + decalage)%26, (colonne+SEUIL)%LW])
            x += EVAL[METHOD](t)
        RHO[decalage][colonne] =  x / 26
print("   ", end="")
for i in range(LW):
    print("%5d" % (i), end=" ")
print()
for ligne in range(26):
    print("%2d: " % (ligne), end="")
    for colonne in range(LW):
        print("%5.3f" % (RHO[ligne][colonne]), end=" ")
    print()



