# friedman_end.py
# on calcule les 26 alphabets (en colonne 1)
# on a besoin des décalages de la roue effective (inclu la 
# position de depart).
# on affiche pour chaque alphabet: les lettres les plus fréquentes, 
# ... la ligne, le décalage
# a faire:

import sys
import string
import getopt
import math

ALPHA = string.ascii_uppercase
# ===================================
def freq(lettres):
    tb = [0]*26
    for let in lettres:
        idx = ALPHA.index(let)
        tb[idx] += 1
    return tb
# ===================================
def IC( f ):
    N = 0 ; total = 0 ; ic = 0
    for i in range(26):
        #if ( f[i] > 1):
        total = total + f[i]*(f[i]-1)
        N += f[i]
    if N > 1:
        ic =  total / float(N * (N-1))
    return ic
# ===================================
def lecture(nom):
    f = open(nom)
    leTexte = f.readlines()
    txt = ""
    for i in range(len(leTexte)):
        ch = leTexte[i].strip()
        ch = ch.upper()
        for j in range(len(ch)):
            if ch[j] in ALPHA:
                txt += ch[j]
    return txt

#--------------------------------------------------
def ic(tb):
    result = 0
    for lettre in ALPHA:
        v = tb.count(lettre)
        result += v * (v - 1)
    x =  result / (len(tb) * (len(tb) - 1))
    return x

#--------------------------------------------------
def chi(tb):
    r2 = 0
    n1 = n2 = 0
    i1,j1,i2,j2 = tb
    for lettre in ALPHA:
        v1 = CASES[i1][j1].count(lettre)
        v2 = CASES[i2][j2].count(lettre)
        n1 += v1
        n2 += v2
        r2 += (v1*v2)
    return r2 / (n1*n2)

#------------------------------------
def chi2(t1, t2):
    max_sum = 0
    max_decal = 0
    for decalage in range(26):
        sum_i = 0
        for i in range(26):
            sum_i += t1[i] * t2[(i+decalage)%26]
        if sum_i >= max_sum:
            max_sum = sum_i
            max_decal = decalage
    new_tb = [0]*26
    for i in range(26):
        new_tb[i] = math.sqrt( t1[i] * t2[(i+max_decal)%26] )
    return max_decal, new_tb
#------------------------------------
def let_max(alphabet):
    tb = []
    for lettre in ALPHA:
        tb.append( alphabet.count(lettre) )
    #print(alphabet, tb)
    a2 = list(ALPHA)
    ch = ""
    for i in range(5):
        x = max(tb)
        z = tb.index(x)
        ch += a2[z] + ":" + str(tb[z]) + ","
        del a2[z]
        del tb[z]
    return ch
# ===================================
def usage():
    print("usage:")
    print("  -h         Help")
    print("  -c crypto	The cryptogram")
    print("  -w liste   The shifts (ex: 3,4,8,7,5), by default")
    print("             The shifts of the standard wheel")
    print("  -v         Verbose (debug)")
#--------------------------------------------------
try:
  opts, args = getopt.getopt(sys.argv[1:], 
    "hc:w:t:v", ["help", "crypto=", "wheel=", "threshold=", "verbose"])
except getopt.GetoptError as err:
  # print help information and exit:
  print(sys.argv[0],": ", str(err)) # option -a not recognized"
  usage()
  sys.exit(2)

DEBUG = False
msg = ""
DECAL = [7,6,7,5,6,7,6,8,6,10,5,6,5,7,6,5,9]

for o, a in opts:
  if o == "-v":
    DEBUG = True
  elif o in ("-h", "--help"):
    usage()
    sys.exit()
  elif o in ("-c", "--crypto"):
    msg = lecture( a )
  elif o in ("-w", "--wheel"):
    tb = a.split(",")
    DECAL = list(map(int,tb))
  elif o in ("-t", "--threshold"):
    SEUIL = int(a)
  else:
    assert False, "unhandled option"
if msg == "" :
  usage()
  sys.exit(1)
#--------------------------------------------------
# ====== DEBUT DU PROGRAMME =========

# == 1. on cree le tableau LWx26
LG = len(msg)
LW = len(DECAL)
CASES = []
for i in range(26):
    CASES.append([""]*LW)

CRYPTO = msg
#print(CRYPTO)
#print(CASES)

# == 2 - on calcule tous les decalages pour toutes les 
#          lettres du crypto
TOUS_LES_DECAL = []
decal_courant = 0
for i in range(LG):
    TOUS_LES_DECAL.append( decal_courant )
    decal_courant += DECAL[ i % LW ]
    decal_courant = (decal_courant % 26)

if DEBUG:
    print(TOUS_LES_DECAL)

# == 3 - on repartie les lettres dans les 26 alphabets
LES_ALPHA = [""]*26
COLONNE_UN = [0]*26
for i in range(LG):
    decal_courant = TOUS_LES_DECAL[i]
    lettre = msg[i]
    LES_ALPHA[ decal_courant ] += lettre

if DEBUG:
    for i in range(26):
        print(LES_ALPHA[i])

# == 4 - on imprime le tableau Fig. 9
print("  ", end="")
for j in range(26):
    print("  %1c" % (ALPHA[j]), end="")
print()
TB_FRIED = []
for i in range(26):
    TB_FRIED.append(list([0]*26))

for i in range(26):
    tb = freq(LES_ALPHA[i])
    for j in range(26):
        TB_FRIED[i][j] = tb[j]
    print("%2d:" % (i), end="")
    for j in range(26):
        print("%2d " % (TB_FRIED[i][j]), end="")
    print()

# == 5 - on imprime le tableau Fig. 10
# le tableau SOM contient un indice et le nombre de lettres
# de chaque alphabet.
TB_INV = []
print()
SOM = []
for i in range(26):
    SOM.append([0]*2)

for i in range(26):
    somme = 0
    tb = []
    print(" %1c:" % (ALPHA[i]), end="")
    for j in range(26):
        print("%2d " % (TB_FRIED[j][i]), end="")
        somme += TB_FRIED[j][i]
        tb.append(TB_FRIED[j][i])
    print(":%3d" % (somme))
    SOM[i][0] = somme
    SOM[i][1] = i
    TB_INV.append( list(tb) )

# == 6 on mixte les colonnes via un Chi2
# -- 6.1 on trie SOM par rapport aux nombres de lettres crypto
print()
SOM_TB = sorted(SOM, reverse=True)

# -- 6.2 on calcule les decalages
LES_DECAL = []   # le numero de la lettre et le decalage
for i in range(26):
    LES_DECAL.append( [0]*2 )
print(SOM_TB[0][1]) # donne 2 (l'alpha ayant le plus de lettres)
base = TB_INV[ SOM_TB[0][1] ] #lettres associees
LES_DECAL[0][0] = SOM_TB[0][1]
LES_DECAL[0][1] = 0
print(LES_DECAL)
for i in range(25):
    autre =  TB_INV[SOM_TB[i+1][1]]  # indice et alpha
    max_decal, new_base = chi2(base, autre)
    LES_DECAL[i+1][0] = SOM_TB[i+1][1]
    LES_DECAL[i+1][1] = max_decal
    #base = new_base

print(LES_DECAL)
print()

# == 7 on affiche les  lettres avec les decal
for i in range(26):
    num_groupe = LES_DECAL[i][0]
    un_alphabet = TB_INV[ num_groupe ]
    decal_courant = LES_DECAL[i][1]
    alpha_decale = un_alphabet[decal_courant:] + un_alphabet[0:decal_courant]
    #print(alpha_decale)
    print("%c: " % (ALPHA[num_groupe]), end="")
    for j in range(26):
        print("%2d " % (alpha_decale[j]), end="")
    print(",%2d" % (decal_courant))

# == 8 affiche l'alphabet interieur
alpha_interne = ["."]*26
collision = False
for i in range(26):
    decalage = LES_DECAL[i][1] 
    lettre = ALPHA[ LES_DECAL[i][0] ]
    emplacement = (0 - decalage)%26
    if alpha_interne[ emplacement ] == ".":
        alpha_interne[ emplacement ] = lettre
    else:
        collision = True

print("Interior Alphabet: ", "".join(alpha_interne), ", Collision: ", collision)

