# friedman_debut.py
# ancien nom: kryha_start.py
# === analyse IC : teste tous les decalages de la roue (roue connue)

import sys
import string
from bib_util2 import *
import getopt

ALPHA = string.ascii_uppercase
# ===================================
def IC( f ):
    N = 0 ; total = 0 ; ic = 0
    for i in range(26):
        #if ( f[i] > 1):
        total = total + f[i]*(f[i]-1)
        N += f[i]
    if N > 1:
        ic =  total / float(N * (N-1))
    return ic

# ===================================
def icBy26Box( msg, offset ):
    lg = len(msg)
    lesAlpha = []
    for i in range(64): lesAlpha.append( [0]*27 )
    for i in range(lg):
        lettre = ALPHA.index(msg[i].upper())
        idx = deplacements[ (i+offset) % len(msg) ]
        lesAlpha[ idx ][ lettre ] += 1
        lesAlpha[ idx ][ 26 ] += 1
    ic_weighted = 0
    for i in range(64):
        ic = IC( lesAlpha[i] )
        weight = lesAlpha[i][26]
        if DEBUG:
            if lesAlpha[i][26] != 0:
                print(i, lesAlpha[i], ic, weight)
        ic_weighted += ic * ( lesAlpha[i][26] / float(lg) )
    return ic_weighted, lesAlpha
# ===================================
def usage():
    print( "usage:")
    print( "  -h         Help")
    print("  -c crypto	The cryptogram")
    print("  -w inc,... The pins of a Wheel, by default, the standard")
    print("  -o offset  The beginning sector, by default, 1")
    print("  -v         Verbose (debug)")
#--------------------------------------------------
try:
  opts, args = getopt.getopt(sys.argv[1:], 
    "hc:w:o:v", ["help", "crypto=", "wheel=", "offset=", "verbose"])
except getopt.GetoptError as err:
  # print help information and exit:
  print(sys.argv[0],": ", str(err)) # option -a not recognized"
  usage()
  sys.exit(2)

DEBUG = False
#WHEEL = [7, 6, 7, 5, 6, 7, 6, 8, 6, 10, 5, 7, 5, 7, 6, 5, 9 ]
WHEEL = [7, 6, 7, 5, 6, 7, 6, 8, 6, 10, 5, 6, 5, 7, 6, 5, 9 ]
mem_sector = 0
OFFSET = -1
msg = ""

for o, a in opts:
  if o == "-v":
    DEBUG = True
  elif o in ("-h", "--help"):
    usage()
    sys.exit()
  elif o in ("-c", "--crypto"):
    msg = lecture( a )
  elif o in ("-w", "--wheel"):
    tb = a.split(",")
    WHEEL = list(map(int, tb ))
  elif o in ("-o", "--offset"):
    mem_sector = int(a) - 1
    OFFSET = mem_sector
  else:
    assert False, "unhandled option"
if msg == "" :
  usage()
  sys.exit(1)
#--------------------------------------------------
# ====== DEBUT DU PROGRAMME =========
print("Wheel:", WHEEL, " Sector: ", mem_sector)
print()

# 1. Calculer la suite des deplacements (num. des alphabets)
mem_sector_init = mem_sector
deplacements = []
mem_numalpha = 0
#mem_sector   = 0
for i in range(len(msg)):
    deplacements.append( mem_numalpha )
    mem_numalpha += WHEEL[ mem_sector ]
    if mem_numalpha > 25 : 
        mem_numalpha = mem_numalpha % 26
    mem_sector += 1
    if mem_sector == len(WHEEL): 
        mem_sector = 0
if DEBUG:
    print(deplacements)

# 2. Calcul de l'IC (ou des ICs)
if OFFSET == -1:
    for i in range(len(WHEEL)):
        lesAlpha = []
        [ic, lesAlpha] = icBy26Box( msg, i )
        print("%3d: %8.6f" % (i+1,ic))
else:
    lesAlpha = []
    [ic, lesAlpha] = icBy26Box( msg, OFFSET )
    print("offset: ", OFFSET, " IC:", ic)

# 3. autres calculs
if OFFSET == -1: 
    sys.exit(0)
total = [0]*26
for i in range(26):
    print("%2d:" % (i), end="")
    for j in range(26):
        print("%2d" % (lesAlpha[i][j]), end="")
        total[(i + j )%26] += lesAlpha[i][j]
    print()
print()
print("Tot:", IC(total)," ")
for i in range(26):
    print(total[i],end="")
print() ; print() 

