# hc_kry_aE.py : Hill Climbing, machine Kryha
import sys
import string
import random
import math
import getopt
import time
import HC_SCORE
import kryha
#==============================
#==============================
def gen_key():
    ALPH=[]
    for i in range(26): ALPH.append(None)
    CODE=""

    N = 0
    for i in range(1000):
        x = random.randrange(26)
        if not ALPH[x]:
            CODE = CODE + string.ascii_uppercase[x] 
            ALPH[x] = 1
            N = N + 1
            if N == 26:
                break
    return CODE
#================================================
def is_maj(car):

        if string.ascii_uppercase.find(car) == -1:
                return 0
        else:
                return 1
# ===================================
def litfic( fic ):
        f = open(fic,"r")
        leTexte = f.readlines()
        texteConcat = ""
        f.close()
        for i in range(len(leTexte)):
                ch = leTexte[i]
                ch = ch.upper()
                for j in range(len(ch)):
                        if not is_maj(ch[j]):
                                continue
                        texteConcat = texteConcat + ch[j]
        return texteConcat
# ===================================
def fitness_IC(texte):
        f = []
        for i in range(26):
                f.append(0)
        N = len(texte)
        for i in range(N):
                indice = string.index(string.ascii_uppercase, texte[i])
                f[indice] = f[indice] + 1
        total = 0
        for i in range(26):
                if ( f[i] > 1):
                        total = total + f[i]*(f[i]-1)
        return total / float(N * (N-1))

#======================================
def new_cle( UNE_CLE ):
    tb = list( UNE_CLE )
    while 1 :
        x1 = random.randint( 0, 25 )
        x2 = random.randint( 0, 25 )
        if x1 == x2 : continue
        tempo = tb[ x1 ]
        tb[ x1 ] = tb[ x2 ]
        tb[ x2 ] = tempo

        return "".join( tb )

#======================================
def setKey(c,key):
    c.reset()
    c.set_alpha_int(key)

#======================================
def dechiffre(c, crypto):
    return c.operate(crypto)

#======================================
def usage():
    print( "usage:")
    print("  -c crypto  The cryptogram")
    print("  -M method  The method (BIG,TRI,...), default: IC")
    print("  -m file_method The file used with method")
    print("  -t tries   Number of tries, default: 15")
    print("  -W start   Initial position of the Wheel: 1 by default")
#======================================
#>>>>>>>>>>>>>>>>>>>>>>>>><<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<
#================== Debut Programme ===========================
try:
  opts, args = getopt.getopt(sys.argv[1:],
    "hc:M:m:t:W:", ["help", "output=", "crypto=","method=",
    "method_file=", "tries=", "wheel="])
except getopt.GetoptError as err:
  # print help information and exit:
  print( sys.argv[0],": ", str(err)) # option -a not recognized"
  usage()
  sys.exit(2)

CRYPTO = ""
random.seed()
MAX_SCORE = 0
file_method = "IC"
METHOD="IC"
MAX_Z = 10
ALPHA  = "ABCDEFGHIJKLMNOPQRSTUVWXYZ"
KEY_MODE  = "C"
MODE_CIPHER = 0
FIRSTOP = 1

for o, a in opts:
  if o == "-v":
    verbose = True
  elif o in ("-h", "--help"):
    usage()
    sys.exit()
  elif o in ("-c", "--crypto"):
    CRYPTO = litfic( a )
  elif o in ("-M", "--method"):
    METHOD = a
  elif o in ("-m", "--method_file"):
    file_method = a
  elif o in ("-t", "--tries"):
    MAX_Z = int(a)
  elif o in ("-W", "--wheel"):
    FIRSTOP = int(a)
  else:
    assert False, "unhandled option"

if CRYPTO  == "" or file_method == "":
  usage()
  sys.exit(1)
HC_SCORE.score_init[METHOD]( file_method )

#>>>>>>>> on essaye 10 fois l'algo Hill Climbing
c = kryha.Kryha_old(Mode_cipher=False, Firstop=FIRSTOP)

for i in range( MAX_Z ):
    #------- KEY_parent
    KEY_parent = gen_key()

    # - on dechiffre avec la cle courante
    setKey(c, KEY_parent)
    CLAIR = dechiffre(c, CRYPTO)
    MAX_CLAIR = CLAIR

    # - on calcule le fitness
    HIGH_SCORE = HC_SCORE.score[METHOD]( CLAIR )
    print( "HIGH_SCORE inital: ", HIGH_SCORE)
    
    #------- on boucle tant qu'il y a amelioration
    j = 0
    while True:
        # - on change legerement la cle
        KEY = new_cle( KEY_parent )

        # - on dechiffre avec la cle courante
        setKey(c, KEY)
        CLAIR = dechiffre(c, CRYPTO)

        # - on calcule le fitness
        score = HC_SCORE.score[METHOD]( CLAIR )

        # - on conserve le score si meilleur
        if score > HIGH_SCORE :
            KEY_parent = KEY        
            HIGH_SCORE = score
            MAX_CLAIR = CLAIR
            j = 0
        else:
            j = j+1

        # - on sort si pas d'ameliroation
        if j > 1000:
            if HIGH_SCORE > MAX_SCORE:
                MAX_SCORE = HIGH_SCORE
                MAX_KEY = KEY_parent
                print(i, MAX_SCORE, MAX_CLAIR[0:50])
            break
    # ------ affiche solution tempo
    #print(i, HIGH_SCORE, MAX_CLAIR[0:50])
# ------ on affiche la solution
print()
print("Cle: ", MAX_KEY, " Score: ", MAX_SCORE)
print("Clair: ", MAX_CLAIR[0:50])
