# hc_substi.py : Hill Climbing for simple substitution
import sys
import string
import random
import math
import HC_SCORE
import getopt
import time
ALPHA = string.ascii_uppercase
#==============================
def gen_key():
    flag=[False]*26
    CODE=""

    N = 0
    for i in range(1000):
        x = random.randrange(26)
        if not flag[x]:
            CODE = CODE + ALPHA[x] 
            flag[x] = True
            N = N + 1
            if N == 26:
                break
    return CODE
#================================================
def is_maj(car):
    if ALPHA.find(car) == -1:
        return 0
    else:
        return 1
# ===================================
def litfic( fic ):
    f = open(fic,"r")
    leTexte = f.readlines()
    texteConcat = ""
    f.close()
    for i in range(len(leTexte)):
        ch = leTexte[i]
        ch = ch.upper()
        for j in range(len(ch)):
            if not is_maj(ch[j]):
                continue
            texteConcat = texteConcat + ch[j]
    return texteConcat
#======================================
def new_cle( UNE_CLE ):
    tb = list( UNE_CLE )
    while 1 :
        x1 = random.randint( 0, 25 )
        x2 = random.randint( 0, 25 )
        if x1 == x2 : continue
        else: break
    tempo = tb[ x1 ]
    tb[ x1 ] = tb[ x2 ]
    tb[ x2 ] = tempo
    return "".join( tb )

#======================================
def code( cle, c):
    x = cle.find(c)
    return ALPHA[x]
#======================================
def dechiffre( cle, ch ):
    clair = ""
    for j in range(len(ch)):
        if ALPHA.find( ch[j] ) != -1:
            clair = clair + code( cle, ch[j])
    return clair

#======================================
def usage():
    print("usage:")
    print("  -c crypto  The cryptogram")
    print("  -M method  The method (BIG,TRI,...), default: BIG")
    print("  -m file_method The file used with method, default: english")
    print("  -t tries   Number of tries, default: 15")
#======================================
#>>>>>>>>>>>>>>>>>>>>>>>>><<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<
#================== Debut Programme ===========================
try:
  opts, args = getopt.getopt(sys.argv[1:],
    "hc:M:m:t:", ["help", "output=", "crypto=","method=",
    "method_file=", "tries="])
except getopt.GetoptError as err:
  print(sys.argv[0],": ", str(err))# option -a not recognized"
  usage()
  sys.exit(2)

CRYPTO = ""
random.seed()
MAX_SCORE = 0
file_method = "english"
METHOD="BIG"
MAX_Z = 10

for o, a in opts:
  if o == "-v":
    verbose = True
  elif o in ("-h", "--help"):
    usage()
    sys.exit()
  elif o in ("-c", "--crypto"):
    CRYPTO = litfic( a )
  elif o in ("-M", "--method"):
    METHOD = a
  elif o in ("-m", "--method_file"):
    file_method = a
  elif o in ("-t", "--tries"):
    MAX_Z = int(a)
  else:
    assert False, "unhandled option"

if CRYPTO  == "" or file_method == "":
  usage()
  sys.exit(1)
HC_SCORE.score_init[METHOD]( file_method )

#>>>>>>>> on essaye 10 fois l'algo Hill Climbing
for i in range( MAX_Z ):
    #------- KEY_parent
    KEY_parent = gen_key()

    # - on dechiffre avec la cle courante
    CLAIR = dechiffre( KEY_parent, CRYPTO )
    MAX_CLAIR = CLAIR

    # - on calcule le fitness
    HIGH_SCORE = HC_SCORE.score[METHOD]( CLAIR )
    
    #------- on boucle tant qu'il y a amelioration
    j = 0
    while 1:
        # - on change legerement la cle
        KEY = new_cle( KEY_parent )
            
        # - on dechiffre avec la cle courante
        CLAIR = dechiffre( KEY, CRYPTO )

        # - on calcule le fitness
        score = HC_SCORE.score[METHOD]( CLAIR )

        # - on conserve le score si meilleur
        if score > HIGH_SCORE :
            KEY_parent = KEY        
            HIGH_SCORE = score
            MAX_CLAIR = CLAIR
            j = 0
        else:
            j = j+1

        # - on sort si pas d'ameliroation
        if j > 1000:
            if HIGH_SCORE > MAX_SCORE:
                MAX_SCORE = HIGH_SCORE
                MAX_KEY = KEY_parent
                #print(i, MAX_SCORE, MAX_CLAIR[0:50])
            break
    # ------ affiche solution tempo
    print(i, HIGH_SCORE, MAX_CLAIR[0:50])
# ------ on affiche la solution
try:
    MAX_KEY
except NameError:
    print("Sorry, I didn't find a key")
else: 
    print()
    print("Key: ", MAX_KEY, " Score: ", MAX_SCORE)
    CLAIR = dechiffre( MAX_KEY, CRYPTO )
    print(CLAIR)

