# kryha.py: la classe KRYHA
# ajouter (dans info) l'affichage des valeurs de toutes les secteurs
# permettre l'utilisation d'alphabets incomplets
# BUG: (16/7/25): boucle infinie:  while pos not in self.stops:
# (on n'a pas précisé le secteur initial)
# --- a faire:
# * choix decal alphabet par une lettre
# * emuler kryha v1
# * mettre à jour méthode info()
import string
import sys
import random

ALPHA = string.ascii_uppercase

class Kryha:
    SHIFTS_V2 = [
            4,3,4,3,3,3,4,3,4,4,3,3,
            3,3,4,4,3,3,4,3,3,4,3,3,
            4,3,3,4,4,4,3,3,4,3,3,3,
            4,3,4,3,3,4,5,3,3,3,3,4,
            3,3,4,5
    ]

    def __init__(self, **args):
        if "Debug" in args:
            self.debug = args["Debug"]
        else:
            self.debug = False
        if "Alpha_int" in args:
            self.alpha_int = args["Alpha_int"]
        else:
            self.alpha_int = ALPHA
        if "Alpha_ext" in args:
            self.alpha_ext = args["Alpha_ext"]
        else:
            self.alpha_ext = ALPHA
        if "Stops" in args:
            self.stops = args["Stops"]
        else:
            self.stops = list(range(1,53))
        if "Mode_cipher" in args:
            self.mode = args["Mode_cipher"]
        else:
            self.mode = True
        if "Firstop" in args:
            self.position = args["Firstop"]
            if self.position == 0:
                self.position = self.stops[0]
        else:
            self.position = self.stops[0]
        if "Init_alpha" in args:
            self.decalage = args["Init_alpha"]
        else:
            self.decalage = 0
        if "Move_before" in args:
            self.begin_advance =  args["Move_before"]
        else:
            self.begin_advance = False
        self.count = 0

    def advance_alpha(self):
        pass

    def advance_disk(self):
        if self.position not in self.stops:
            print("\nPosition must correspond to an Hole:")
            sys.exit(1)
        total = un_decal = Kryha.SHIFTS_V2[ self.position - 1 ]
        self.decalage += un_decal
        self.position = self.position + 1
        if self.position > (len(Kryha.SHIFTS_V2)):
            self.position = 1
        while self.position not in self.stops:
            un_decal = Kryha.SHIFTS_V2[ self.position - 1 ]
            total += un_decal
            self.decalage += un_decal
            self.decalage = (self.decalage)%26
            self.position = self.position + 1 
            if self.position > (len(Kryha.SHIFTS_V2)):
                self.position = 1
        if self.debug:
            print("Shift: %2d, Cumuled shift: %2d, Disk Position: %2d" \
                %(total, self.decalage, self.position))
            print()

    def cipher(self, c):
        x0 = x = (self.alpha_ext).index(c)
        x = (26 + x - self.decalage) % 26
        y = self.alpha_int[x]
        return y

    def decipher(self, c):
        x = (self.alpha_int).index(c)
        x = (x + self.decalage) % 26
        y = self.alpha_ext[x]
        return y

    def operate(self, txt):
        result = ""
        if self.begin_advance:
            self.advance_disk()
        for c in txt:
            fenetre = self.alpha_int[(26-self.decalage):] + \
                self.alpha_int[0:(26-self.decalage)]
            if self.debug:
                print("Internal alphabet: ", fenetre)
                print("External alphabet: ", self.alpha_ext)
            if self.mode:
                car_out = self.cipher(c)
            else:
                car_out = self.decipher(c)
            result += car_out
            if self.debug:
                print("%3d - %c => %c " % (self.count, c, car_out), end=",")
            self.count += 1
            self.advance_disk()
        return result

    def info(self):
        ch = ""
        """
        sectors = []
        pos = self.stops[0]
        decal = 0
        while True:
            decal += Kryha.SHIFTS_V2[ pos - 1 ]
            pos += 1
            if pos > 52: 
                pos = 1
            while pos not in self.stops:
                decal += Kryha.SHIFTS_V2[ pos - 1 ]
                pos += 1
                if pos > 52:
                    pos = 1
            sectors.append(decal)
            decal = 0
            if pos == 1: break
        """
        ch += "Internal Alphabet: " + self.alpha_int + "\n"
        ch += "External Alphabet: " + self.alpha_ext + "\n"
        ch += "Stops: " + str(self.stops) + "\n"
        ch += "First stop: " + str(self.position) + "\n"
        #ch += "Sectors: " + str(sectors) + "\n"
        #ch += "Number of sectors: " + str(len(sectors)) + "\n"
        ch += "Cipher Mode: " + str(self.mode) + "\n"
        ch += "Initial shift for internal alphabet: " \
            + str(self.decalage) + "\n"
        ch += "Advance before cipher: " \
            + str(self.begin_advance) + "\n"
        return ch


#==============================
class Kryha_old:
    def __init__(self, 
            Alpha_ext=ALPHA,
            Alpha_int=ALPHA,
            Roue="DEFAULT", 
            Shifts= [],
            Firstop=1,
            Init_alpha=0,
            Mode_cipher=True,
            Move_before=False,
            Debug=False):

        self.alpha_ext = Alpha_ext
        self.alpha_int = Alpha_int
        if Roue == "DEFAULT":
            self.decal_systematik = 0
            if len(Shifts) == 0:
                nom_roue = "17"
                secteurs = [7,6,7,5,6,7,6,8,6,10,5,6,5,7,6,5,9]
                self.roue =[3,2,3,1,2,3,2,4,2, 6,1,2,1,3,2,1,5]
            else:
                secteurs = Shifts        
                self.roue = Shifts
        else:
            self.decal_systematik = 4
            nom_roue = Roue
            fic = open("keys/"+nom_roue+".whl","r")
            ch = (fic.readline()).strip()
            ch = ch.split(",")
            secteurs = list(map(int,ch))
            self.roue = list(secteurs)
        self.sects = []
        for i in range(len(secteurs)):
            self.sects.append( int(secteurs[i]) + self.decal_systematik)
        self.d_ini = Firstop
        self.indx  = Firstop - 1 
        self.decal = Init_alpha
        self.avance = Move_before
        self.debug = Debug

        self.courant = 0
        self.compt = 0
        self.alpharev = ""
        if Mode_cipher:
            self.mode = "CHIFR"
        else:
            self.mode = "DECHI"

    def reset(self):
        self.compt = 0
        self.count = 0
        self.decal = 0
        self.indx = self.d_ini - 1

    def set_alpha_ext(self, alphabet):
        self.alpha_ext = alphabet

    def set_alpha_int(self, alphabet):
        self.alpha_int = alphabet

    def decaler(self):
        if self.compt == 0 and not self.avance :
            self.courant = 0
            self.indx = self.indx - 1
        else:
            self.decal = ( self.decal + (self.sects[ self.indx ])) % 26
            self.courant = self.sects[ self.indx ]
        self.alpharev = self.alpha_int[(26-self.decal):]  +  \
            self.alpha_int[0:(26-self.decal)]     
        if self.debug :    
            print("\t", self.alpharev)
            print("\t", self.alpha_ext)
        self.indx = self.indx + 1
        if self.indx == len(self.sects):
            self.indx = 0
        self.compt = self.compt + 1

    def setDecalRoue(self, decal):
        self.indx = (decal - 1) % len(self.sects)

    def coder(self,alpha,c,x):
        r = alpha[x]
        if self.debug :
            print("%04d : %02d, [%02d] , %1s -> %1s" % \
                (self.compt,self.decal, self.courant,c,r))
        return r

    def chiffre(self, c):
        self.decaler()
        x = (self.alpha_ext).index(c)
        
        x = (26 + x - self.decal) % 26
        return self.coder(self.alpha_int,c,x)

    def dechiffre(self, c):
        self.decaler()
        x = (self.alpha_int).index(c)
        x = (x + self.decal) % 26
        return self.coder(self.alpha_ext,c,x)

    def operate(self, leTexte):
        chiffre = ""
        for i in range(len(leTexte)):
            ch = leTexte[i].strip()
            ch = ch.upper()
            for j in range(len(ch)):
                if ALPHA.find( ch[j] ) != -1:
                    if self.mode == "CHIFR" :
                        lettre = self.chiffre(ch[j])
                    else:
                        lettre = self.dechiffre(ch[j])
                    chiffre = chiffre + lettre 
                else:
                    chiffre = chiffre + ch[j] 
    
        return chiffre

    def info(self):
        ch = ""
        ch += "Wheel: " + str(self.roue) + "\n"
        ch += "Sectors: " + str(self.sects) + ">>" + str(len(self.sects)) + "\n"
        ch += "First stop: " + str(self.d_ini) + "\n"
        if self.mode == "CHIFR":
            ch += "Cipher Mode: cipher\n"
        else:
            ch += "Cipher Mode: decipher\n"
        ch += "Initial shift for internal alphabet: " + str(self.decal) + "\n"
        ch += "Advance before cipher: " + str(self.avance) + "\n"
        ch += "Systematik shift: " + str(self.decal_systematik) + "\n"
        ch += "Internal alphabet: " + self.alpha_int + "\n"
        ch += "External alphabet: " + self.alpha_ext + "\n"
        return ch
        
if __name__ == "__main__":
    h = Kryha()
    result = h.operate("HELLO")
    print(result)


    h = Kryha_old()
    result = h.operate("SALUT")
    print(result)

