# kryha_tui.py 
# A faire:
# * mini fonctionnel
# - on chiffre (pas de dechiff) alpha ordonnes decalage pre-existant
#   position alpha initial == 0

import string
import sys
import getopt
from kryha import *

# ==================================
def valide_alpha(txt):
    if len(txt) != 26: 
        print(txt, " : not valid alphabet (length != 26)")
        sys.exit(1)
    FINDED = ""
    for c in txt:
        if c not in ALPHA:
            print(txt, " : not valid alphabet (contains not only letters)")
            sys.exit(1)
        if c not in FINDED:
            FINDED += c
    if len(FINDED) != 26:
        print(txt, " : not valid alphabet (not 26 differents letters)", FINDED)
        sys.exit(1)

# ==================================
def litfic( fic ):
    f = open(fic,"r")
    leTexte = f.readlines()
    texteConcat = ""
    f.close()
    for i in range(len(leTexte)):
        ch = leTexte[i]
        ch = ch.upper()
        for j in range(len(ch)):
            if not is_maj(ch[j]):
                continue
            texteConcat = texteConcat + ch[j]
    return texteConcat

# ================================================
def usage():
    print("usage:")
    print("Syntax: kryha_tui.py [option...]")
    print("Example: ")
    print(" echo AAAA|python kryha_tui.py -c")
    print("Options:")
    print(" -h          Help")
    print(" -v/-D       Verbose (Debug)")
    print(" -o          Old model (V1), by default V2")
    print(" -i alpha    Internal alphabet (ABC... by default)")
    print(" -e alpha    External alphabet (ABC... by default)")
    print(" -s stops    V1: Shifts, for example: 6,10,7,10,3,10")
    print("             V2: Stops (Holes), 1,2,3,...52 by default")
    print("             ")
    print(" -f stop     Initial stop (the first stop by default)")
    print(" -a letter   Initial shift for internal alphabet")
    print(" -c/-d       Cipher/Decipher (Cipher by default)")
    print("             if Mode is Cipher we read the plain ")
    print("             letters in the External alphabet")
    print(" -m          Move the Internal disk before ciphering")
    print("             By default, don't move the disk before ciphering")
    print(" -w wheel    The wheel (only for old model), DEFAULT by default")
    print("             The wheel.whl file must be in 'keys' directory")
# ================================================
try:
  opts, args = getopt.getopt(sys.argv[1:],
    "hDoi:e:s:f:a:cdmw:", ["help", "debug", "old", "internal=", "external=",
        "stops=", "firstop=", "initalpha=", "cipher", "decipher",
        "move", "wheel=" ])
except getopt.GetoptError as err:
  # print help information and exit:
  print(sys.argv[0],": ", str(err))# option -a not recognized"
  usage()
  sys.exit(2)

DEBUG = False
ALPHA_INT = ALPHA
ALPHA_EXT = ALPHA
STOPS = list(range(1,53))
STOPS_FIX = False
FIRSTOP = 1
INIT_ALPHA = 0
MODE_CIPHER = True
MOVE_BEFORE = False
MODEL = "V2"
ROUE= "DEFAULT"

for o, a in opts:
  if   o in ("-v", "--verbose", "-D", "--debug"):
    DEBUG = True
  elif o in ("-h", "--help"):
    usage()
    sys.exit()
  elif o in ("-i", "--internal"):
    valide_alpha(a)
    ALPHA_INT = a
  elif o in ("-e", "--external"):
    valide_alpha(a)
    ALPHA_EXT = a
  elif o in ("-s", "--stops"):
    stops_obj = map(int, a.split(","))
    STOPS = list(stops_obj)
    STOPS_FIX = True
  elif o in ("-f", "--firstop"):
    FIRSTOP = int(a)
  elif o in ("-a", "--initalpha"):
    INIT_ALPHA = int(a)
  elif o in ("-c", "--cipher"):
    MODE_CIPHER = True
  elif o in ("-d", "--decipher"):
    MODE_CIPHER = False
  elif o in ("-m", "--move"):
    MOVE_BEFORE = True    
  elif o in ("-o", "--old"):
    MODEL = "V1"
  elif o in ("-w", "--wheel"):
    ROUE = a
  else:
    assert False, "unhandled option"

# ================================================
ALPHA = string.ascii_uppercase
VALID_LETTERS = ALPHA
the_text = sys.stdin.readlines()
input_txt = ""

for i in range(len(the_text)):
    ch = the_text[i]
    ch = ch.upper()
    for j in range(len(ch)):
        car = ch[j]
        if car in VALID_LETTERS:
            input_txt += car

if MODEL == "V2":
    h = Kryha(
        Alpha_int=ALPHA_INT, 
        Alpha_ext=ALPHA_EXT, 
        Stops=STOPS,
        Debug=DEBUG,
        Firstop=FIRSTOP,
        Init_alpha = INIT_ALPHA,
        Mode_cipher = MODE_CIPHER,
        Move_before = MOVE_BEFORE
    )
else:
    if not STOPS_FIX:
        STOPS = []

    h = Kryha_old(
        Alpha_int=ALPHA_INT,
        Alpha_ext=ALPHA_EXT,
        Roue=ROUE,
        Shifts=STOPS,
        Firstop=FIRSTOP,
        Init_alpha = INIT_ALPHA,
        Mode_cipher = MODE_CIPHER,
        Move_before = MOVE_BEFORE,
        Debug=DEBUG
    )
if DEBUG:
    print(h.info())
output_txt = h.operate(input_txt)
print(output_txt)

