# sacco_alpha.py
# on utilise la méthode Sacco, on calcule les 26 alphabets (en colonne 1)
# on a besoin des décalages par chaque colonne ...
# on affiche pour chaque alphabet: les lettres les plus fréquentes, la ligne, le décalage
# a faire:

import sys
import string
import getopt

ALPHA = string.ascii_uppercase
# ===================================
def freq(lettres):
    tb = [0]*26
    for let in lettres:
        idx = ALPHA.index(let)
        tb[idx] += 1
    return tb
# ===================================
def IC( f ):
    N = 0 ; total = 0 ; ic = 0
    for i in range(26):
        #if ( f[i] > 1):
        total = total + f[i]*(f[i]-1)
        N += f[i]
    if N > 1:
        ic =  total / float(N * (N-1))
    return ic
# ===================================
def lecture(nom):
    f = open(nom)
    leTexte = f.readlines()
    txt = ""
    for i in range(len(leTexte)):
        ch = leTexte[i].strip()
        ch = ch.upper()
        for j in range(len(ch)):
            if ch[j] in ALPHA:
                txt += ch[j]
    return txt

#--------------------------------------------------
def ic(tb):
    result = 0
    for lettre in ALPHA:
        v = tb.count(lettre)
        result += v * (v - 1)
    x =  result / (len(tb) * (len(tb) - 1))
    return x

#--------------------------------------------------
def chi(tb):
    r2 = 0
    n1 = n2 = 0
    i1,j1,i2,j2 = tb
    #print("Alpha 1: ", CASES[i1][j1])
    #print("Alpha 2: ", CASES[i2][j2])
    for lettre in ALPHA:
        v1 = CASES[i1][j1].count(lettre)
        v2 = CASES[i2][j2].count(lettre)
        n1 += v1
        n2 += v2
        r2 += (v1*v2)
    #print(r2,r2/n)
    #return result
    return r2 / (n1*n2)

#------------------------------------
def let_max(alphabet):
    tb = []
    for lettre in ALPHA:
        tb.append( alphabet.count(lettre) )
    #print(alphabet, tb)
    a2 = list(ALPHA)
    ch = ""
    for i in range(5):
        x = max(tb)
        z = tb.index(x)
        ch += a2[z] + ":" + str(tb[z]) + ","
        del a2[z]
        del tb[z]
    return ch
# ===================================
def usage():
    print("usage:")
    print("  -h         Help")
    print("  -c crypto	The cryptogram")
    print("  -m liste   The shifts (ex: 3,4,8,7,5)")
    print("  -v         Verbose (debug)")
#--------------------------------------------------
try:
  opts, args = getopt.getopt(sys.argv[1:], 
    "hc:m:t:v", ["help", "crypto=", "maximum=", "threshold=", "verbose"])
except getopt.GetoptError as err:
  # print help information and exit:
  print(sys.argv[0],": ", str(err)) # option -a not recognized"
  usage()
  sys.exit(2)

DEBUG = False
msg = ""
DECAL = None

for o, a in opts:
  if o == "-v":
    DEBUG = True
  elif o in ("-h", "--help"):
    usage()
    sys.exit()
  elif o in ("-c", "--crypto"):
    msg = lecture( a )
  elif o in ("-m", "--maximum"):
    tb = a.split(",")
    DECAL = list(map(int,tb))
  elif o in ("-t", "--threshold"):
    SEUIL = int(a)
  else:
    assert False, "unhandled option"
if msg == "" :
  usage()
  sys.exit(1)
#--------------------------------------------------
# ====== DEBUT DU PROGRAMME =========

# == 1. on cree le tableau LWx26
LG = len(msg)
LW = len(DECAL)
CASES = []
for i in range(26):
    CASES.append([""]*LW)
LES_ALPHA = []

CRYPTO = msg
#print(CRYPTO)
#print(CASES)

# == 2 - on repartie les lettres dans les 26xLW cases
for i in range(len(CRYPTO)):
    idx_i = (i // LW) % 26
    idx_j = i %  LW
    CASES[idx_i][idx_j] += CRYPTO[i]

# == 3 - on repartie les lettres dans les 26 alphabets
for i in range(26):
    ch = "" 
    for j in range(LW):
        ch += CASES[(i+DECAL[j])%26][j]
    LES_ALPHA.append(ch)

# == 4 - on imprime
if DEBUG:
    print("  ", end="")
    for j in range(26):
        print("  %1c" % (ALPHA[j]), end="")
    print()
    TB_FRIED = []
    for i in range(26):
        TB_FRIED.append(list([0]*26))

for i in range(26):
    if  DEBUG:
        tb = freq(LES_ALPHA[i])
        for j in range(26):
            TB_FRIED[j][i] = tb[j]
        print("%2d:" % (i), end="")
        for j in range(26):
            print("%2d " % (tb[j]), end="")
        print()
    else:
        print("%2d, %5.3f %s" % (i,ic(LES_ALPHA[i]),let_max(LES_ALPHA[i])))

if DEBUG:
    print()
    print("  ", end="")
    for j in range(26):
        print(" %2d" % (j), end="")
    print()
    for i in range(26):
        somme = 0
        print(" %1c:" % (ALPHA[i]), end="")
        for j in range(26):
            print("%2d " % (TB_FRIED[i][j]), end="")
            somme += TB_FRIED[i][j]
        print(":%3d" % (somme))

print("Debug:" , DEBUG)
