# superpose.py
# === On teste tous les decalages (roue inconnue) 
#     et on compte nb de coincidence
# a faire:

import sys
import string
import getopt

ALPHA = string.ascii_uppercase
# ===================================
def IC( f ):
    N = 0 ; total = 0 ; ic = 0
    for i in range(26):
        #if ( f[i] > 1):
        total = total + f[i]*(f[i]-1)
        N += f[i]
    if N > 1:
        ic =  total / float(N * (N-1))
    return ic
# ===================================
def lecture(nom):
    f = open(nom)
    leTexte = f.readlines()
    txt = ""
    for i in range(len(leTexte)):
        ch = leTexte[i].strip()
        ch = ch.upper()
        for j in range(len(ch)):
            if ch[j] in ALPHA:
                txt += ch[j]
    return txt

#--------------------------------------------------
def dechiffre(idx, alphabet = ALPHA):
    dechif = ""
    decalage = 0
# ===================================
def usage():
    print("usage:")
    print("  -h         Help")
    print("  -c crypto	The cryptogram")
    print("  -m maximum Maximum of the value of the shift")
    print("  -t value   Threshold (number of superpositions)")
    print("  -v         Verbose (debug)")
#--------------------------------------------------
try:
  opts, args = getopt.getopt(sys.argv[1:], 
    "hc:m:t:v", ["help", "crypto=", "maximum=", "threshold=", "verbose"])
except getopt.GetoptError as err:
  # print help information and exit:
  print(sys.argv[0],": ", str(err)) # option -a not recognized"
  usage()
  sys.exit(2)

DEBUG = False
msg = ""
SEUIL = 0
MAXIMUM = 500

for o, a in opts:
  if o == "-v":
    DEBUG = True
  elif o in ("-h", "--help"):
    usage()
    sys.exit()
  elif o in ("-c", "--crypto"):
    msg = lecture( a )
  elif o in ("-m", "--maximum"):
    MAXIMUM = int(a)
  elif o in ("-t", "--threshold"):
    SEUIL = int(a)
  else:
    assert False, "unhandled option"
if msg == "" :
  usage()
  sys.exit(1)
#--------------------------------------------------
# ====== DEBUT DU PROGRAMME =========

# == 1. on decale
LG = len(msg)
DECAL = [0]*LG

for S in range(MAXIMUM):
    nc = 0   # number of coincidences
    for i in range(LG):
        let1 = msg[i]
        let2 = msg[(i+S)%LG]
        if let1 == let2: 
            nc += 1
        if DEBUG:
            print(S, i,let1,let2,nc)
    if nc >= SEUIL:
        print("%4d => %5d, %5.3f" % (S,nc, nc/LG))

