# m209_tui.py 
# obj: a M-209 cipher machine with TUI (Text User Interface)

import sys
from m209 import *
import string
import getopt

#======================================
def usage():
    print "usage:"
    print "Syntax : m209_tui.py [options...]"
    print "Example: echo AAAAA | python m209_tui.py -I MB "
    print "         the Internal Key file need to end by .key"
    print "Options:"
    print "  -P pins     The Pins as a binary number of 131 digits"
    print "              (ex: 0101...001, Transport Key by default: 0000...000)"
    print "  -L lugs     The lugs (ex: 1:5:4:13:2:7, Transport Key by default)"
    print "  -O overlaps The overlaps (ex: 0:0:1...:1:1, 0:0:...:0 by default"
    print "  -I internal The internal key file"
    print "  -E external The external key (AAAAAA by default)" 
    print "  -d          Decipher Mode (Z=' ')"
    print "  -g          Print ciphertext by group of 5 letters"
    print "  -D          Debug Mode"
#======================================
try:
  opts, args = getopt.getopt(sys.argv[1:],
    "hP:L:O:I:E:Ddg", ["help","pins=", "lugs=", "overlaps=", "internal=",
    "external=", "debug", "decipher", "group" ])
except getopt.GetoptError as err:
  # print help information and exit:
  print sys.argv[0],": ", str(err) # option -a not recognized"
  usage()
  sys.exit(2)

GROUP5L = False
DEBUG = False
DECIPHER_MODE = False
PINS = "000000000000000000000000000000" + "000000000000000000000000000000"+\
       "000000000000000000000000000000" + "000000000000000000000000000000"+\
       "00000000000"
CH_LUGS = "0:0:0:0:0:0"
CH_OVER = "0:0:0:0:0:0:0:0:0:0:0:0:0:0:0"
KEYEXTERN = "AAAAAA"

c = Hagelin( "Z", DEBUG)
c.setExternalKey(KEYEXTERN)
c.setLugs(map(int,CH_LUGS.split(":")))
c.setOver(map(int,CH_OVER.split(":")))
c.setAllPinsAllW(PINS)

for o, a in opts:
  if   o in ("-D", "--debug"):
    DEBUG = True
    c.setDebug(DEBUG)
  elif o in ("-h", "--help"):
    usage()
    sys.exit()
  elif o in ("-I", "--internal"):
    restore(c,a)
  elif o in ("-L", "--lugs"):
    CH_LUGS=a
    c.setLugs(map(int,CH_LUGS.split(":")))
  elif o in ("-P", "--pins="):
    PINS = a
    c.setAllPinsAllW(PINS)
  elif o in ("-O", "--overlaps="):
    CH_OVER = a
    c.setOver(map(int,CH_OVER.split(":")))
  elif o in ("-E", "--external="):
    c.setExternalKey(a)
  elif o in ("-d", "--decipher"):
    DECIPHER_MODE = True 
  elif o in ("-g", "--group"):
    GROUP5L = True
  else:
    assert False, "unhandled option"

if DEBUG : c.info()
#--------------------------------------
leTexte = sys.stdin.readlines()
crypto = "" 
n = 0
for i in range(len(leTexte)):
    ch = leTexte[i]
    ch = ch.upper()
    for j in range(len(ch)):
        if not is_maj(ch[j]):
            continue
        car = c.cipher(ch[j])
        if car == "Z" and DECIPHER_MODE: car = " "
        if (n % 5) == 0 and GROUP5L and n != 0: crypto += " "
        crypto = crypto + car
        n += 1
print crypto
