# make_key_1942.py
# Create a Internal setting for a M-209
# using the "TM 11-380 1942" rules

from m209 import *
import random
import getopt

def newPins():
    tb = []
    tb = [0] * 78 + [1] * 78 
    random.shuffle( tb )
    random.shuffle( tb )
    random.shuffle( tb )
    random.shuffle( tb )
    Pins = ""
    for i in range(131):
        if tb[i]:
            Pins += "1"
        else:
            Pins += "0"
    # --- verify
    if DEBUG: print Pins,
    Nb_actives = 0
    for i in range(131):
        if Pins[i] == "1": Nb_actives += 1
    percentage = float(Nb_actives) / 131.
    if DEBUG: print "% = ", percentage
    return Pins
#-----------------------------------------------------
def newLugs(c):
    Lugs = [0]*6
    while 1:
        # --- create 6 Lugs at random. Maximum value: 13, Min: 1
        for i in range(6):
            Lugs[i] = random.randint(1,13)
        # --- must be at least a value = 1
        if sorted( Lugs )[0] != 1: continue
        # --- verify sum (must be >=28 and <= 39
        theSum = 0
        for i in range(6):
            theSum += Lugs[i]
        if not( theSum >= 28 and theSum <= 39 ):
            if DEBUG: print "Not between(28,39): ", Lugs
            continue
        # --- verify that Three of the numbers should be odd and three even
        nbOdd = 0
        for i in range(6):
            if (Lugs[i] % 2) == 0: nbOdd += 1
        if nbOdd != 3:
            if DEBUG: print "There aren't three numbers odd", Lugs
            continue
        # --- calculate Overlaps
        lugs2 = list(Lugs)
        nbover = theSum - 27
        if DEBUG: print "Numbers of Overlaps: ", nbover
        overlaps = { '1-2':0, '1-3':0, '1-4':0, '1-5':0, '1-6':0, '2-3':0, \
                     '2-4':0, '2-5':0, '2-6':0, '3-4':0, '3-5':0, '3-6':0, \
                     '4-5':0, '4-6':0, '5-6':0 }    
        overkeys = overlaps.keys()
        flag = 0
        for i in range( nbover ):
            flag2 = 0
            for j in range(100000):
                un_over = random.choice( overkeys )
                n1 =  int( un_over[0] ) -1
                n2 =  int( un_over[2] ) -1
                if lugs2[n1] > 0 and lugs2[n2] > 0 :
                    overlaps[ un_over ] += 1
                    lugs2[n1] -= 1
                    lugs2[n2] -= 1
                    flag2 = 1
                    break
            if flag2 == 0:
                flag = 1
                break
        if flag == 1: 
            if DEBUG: print "Error bcl", Lugs, overlaps
            continue
        if DEBUG: print overlaps
        for key in overlaps.keys():
            c.setOverByKey(key, overlaps[key])
        # --- combinaisons must yield all the numbers from 1 to 27
        valeurs = [0] * 28
        valeurs[0] = 1
        for v in range(64):
            ch = bin(64 + v )
            activesPins = []
            for j in range(6):
                activesPins.append( int( ch[3 + j] ) )
            shift = 0
            for j in range( 6 ):
                shift = shift + activesPins[j] * Lugs[j]
            o = overlaps
            shift = shift - o['1-2'] * activesPins[0] * activesPins[1]
            shift = shift - o['1-3'] * activesPins[0] * activesPins[2]
            shift = shift - o['1-4'] * activesPins[0] * activesPins[3]
            shift = shift - o['1-5'] * activesPins[0] * activesPins[4]
            shift = shift - o['1-6'] * activesPins[0] * activesPins[5]
            shift = shift - o['2-3'] * activesPins[1] * activesPins[2]
            shift = shift - o['2-4'] * activesPins[1] * activesPins[3]
            shift = shift - o['2-5'] * activesPins[1] * activesPins[4]
            shift = shift - o['2-6'] * activesPins[1] * activesPins[5]
            shift = shift - o['3-4'] * activesPins[2] * activesPins[3]
            shift = shift - o['3-5'] * activesPins[2] * activesPins[4]
            shift = shift - o['3-6'] * activesPins[2] * activesPins[5]      
            shift = shift - o['4-5'] * activesPins[3] * activesPins[4]
            shift = shift - o['4-6'] * activesPins[3] * activesPins[5]
            shift = shift - o['5-6'] * activesPins[4] * activesPins[5]
            valeurs[ shift ] = 1
        flag = 0
        for i in range(28):
            if valeurs[i] == 0: flag = 1
        if flag:
            if DEBUG: print "Error: not all values ",Lugs,valeurs,overlaps
            continue                
        # --- return if all tests are good
        break
    if DEBUG: print sorted(Lugs)
    return Lugs
#-----------------------------------------------------
def printKeyList(c):
    wheels = []
    wheels.append( "ABCDEFGHIJKLMNOPQRSTUVWXYZ" )
    wheels.append( "ABCDEFGHIJKLMNOPQRSTUVXYZ" )
    wheels.append( "ABCDEFGHIJKLMNOPQRSTUVX" )
    wheels.append( "ABCDEFGHIJKLMNOPQRSTU" )
    wheels.append( "ABCDEFGHIJKLMNOPQRS" )
    wheels.append( "ABCDEFGHIJKLMNOPQ" )
    for aWheel in range(6):
        ch = ""
        for aPin in range(len(wheels[aWheel])):
            value = c.getPins( aWheel, wheels[aWheel][aPin] )
            if value: ch += wheels[aWheel][aPin]
            else:     ch += "_"
        print ch
    print "Z"
    Lugs = c.getLugs()
    Lugs_ch = map(str,Lugs)
    print ":".join(Lugs_ch)
    over = c.getOver()
    overlaps = [ '1-2', '1-3', '1-4', '1-5', '1-6', '2-3', \
                 '2-4', '2-5', '2-6', '3-4', '3-5', '3-6', \
                 '4-5', '4-6', '5-6' ]
    nbLineOver = 0
    for i in range(len(over)):
        if int(over[i]) > 0: nbLineOver += 1
    print nbLineOver
    for i in range(len(over)):
        if int(over[i]) > 0:
            print "%s:%s" % (overlaps[i], over[i])
    print

def usage():
    print "Usage"
#=====================================================
DEBUG = False
if __name__ == "__main__":
    try:
        opts, args = getopt.getopt(sys.argv[1:],
        "hd", ["help","debug" ])
    except getopt.GetoptError as err:
        # print help information and exit:
        print sys.argv[0],": ", str(err) # option -a not recognized"
        sys.exit(2)
    for o, a in opts:
        if   o in ("-d", "--debug"):
            DEBUG = True
        elif o in ("-h", "--help"):
            usage()
            sys.exit()
        else:
            usage()
            sys.exit()

    # --- create a cipher machine
    c = Hagelin('Z',0)
    
    # --- generate Pins
    Pins = newPins()
    c.setAllPinsAllW( Pins )

    # --- generate Lugs
    Lugs = newLugs(c)
    c.setLugs(Lugs)

    # --- print Internal Key
    printKeyList(c)

