# make_key_1942.py
# Create a Internal setting for a M-209 cipher machine
# using the "TM 11-380 1944" rules

from m209 import *
import random
import getopt

GroupA = [
    [1,2,3,4,8,10], [1,2,3,5,8,11], [1,2,4,7,8,9],
    [1,2,3,4,7,11], [1,2,3,5,7,12], [1,2,3,4,10,12],
    [1,2,3,4,6,12], [1,2,3,5,6,13], [1,2,3,4,9,13],
    [1,2,3,4,5,13], [1,2,3,6,8,10], [1,2,3,5,10,11],
    [1,2,3,5,8,9],  [1,2,3,6,7,11], [1,2,3,5,9,12],
    [1,2,3,5,7,10], [1,2,3,7,8,9],  [1,2,3,5,8,13],
    [1,2,3,5,6,11], [1,2,4,5,8,10], [1,2,3,6,9,11],
    [1,2,3,6,7,9],  [1,2,4,5,7,11], [1,2,3,6,8,12],
    [1,2,4,5,7,9],  [1,2,4,5,6,12], [1,2,3,6,7,13],
    [1,2,4,5,6,10], [1,2,4,6,8,9],  [1,2,3,7,9,10],
    [1,2,3,4,9,10], [1,2,4,6,7,10], [1,2,3,7,8,11],
    [1,2,3,4,8,11], [1,2,3,4,10,11],[1,2,4,5,9,11],
    [1,2,3,4,7,12], [1,2,3,4,9,12], [1,2,4,5,8,12],
    [1,2,3,4,6,13], [1,2,3,4,8,13], [1,2,4,5,7,13],
    [1,2,3,5,8,10], [1,2,3,5,9,11], [1,2,4,6,9,10],
    [1,2,3,5,7,11], [1,2,3,5,8,12], [1,2,4,6,8,11],
    [1,2,3,5,6,12], [1,2,3,5,7,13], [1,2,4,6,7,12],
    [1,2,3,6,8,9],  [1,2,3,6,9,10], [1,2,4,7,8,10],
    [1,2,3,6,7,10], [1,2,3,6,8,11], [1,2,3,4,11,12],
    [1,2,4,5,8,9],  [1,2,3,6,7,12], [1,2,3,4,10,13],
    [1,2,4,5,7,10], [1,2,3,7,8,10], [1,2,3,5,10,12],
    [1,2,4,5,6,11], [1,2,4,5,9,10], [1,2,3,5,9,13],
    [1,2,4,6,7,9],  [1,2,4,5,8,11], [1,2,3,6,10,11],
    [1,2,3,4,9,11], [1,2,4,5,7,12], [1,2,3,6,9,12],
    [1,2,3,4,8,12], [1,2,4,5,6,13], [1,2,3,6,8,13],
    [1,2,3,4,7,13], [1,2,4,6,7,11], [1,2,3,7,9,11],
    [1,2,3,5,9,10], [1,2,4,6,8,10], [1,2,3,7,8,12],

    [1,2,4,5,10,11],[1,2,4,7,9,11], [1,2,4,6,10,13],
    [1,2,4,5,9,12], [1,2,4,7,8,12], [1,2,4,6,11,12],
    [1,2,4,5,8,13], [1,2,4,8,9,10], [1,2,4,7,10,12],
    [1,2,4,6,8,12], [1,2,3,5,11,13],[1,2,4,7,9,13],
    [1,2,4,6,9,11], [1,2,3,6,11,12],[1,2,4,8,10,11],
    [1,2,4,6,7,13], [1,2,3,6,10,13],[1,2,4,8,9,12],
    [1,2,4,7,9,10], [1,2,3,7,10,12],[1,2,3,6,12,13],
    [1,2,4,7,8,11], [1,2,3,7,9,13], [1,2,3,7,11,13],
    [1,2,3,4,11,13],[1,2,4,5,11,12],[1,2,4,5,12,13],
    [1,2,3,5,11,12],[1,2,4,5,10,13],[1,2,4,6,11,13],
    [1,2,3,5,10,13],[1,2,4,6,9,13], [1,2,4,7,11,12],
    [1,2,3,6,10,12],[1,2,4,6,10,12],[1,2,4,7,10,13],
    [1,2,3,6,9,13], [1,2,4,7,10,11],[1,2,4,8,9,13],
    [1,2,3,7,10,11],[1,2,4,7,9,12], [1,2,4,8,10,12],
    [1,2,3,7,9,12], [1,2,4,7,8,13], [1,2,3,7,12,13],
    [1,2,3,7,8,13], [1,2,4,8,9,11], [1,2,4,6,12,13],
    [1,2,4,5,10,12],[1,2,3,5,12,13],[1,2,4,7,11,13],
    [1,2,4,5,9,13], [1,2,3,6,11,13],[1,2,4,8,11,12],
    [1,2,4,6,8,13], [1,2,3,7,11,12],[1,2,4,8,10,13],
    [1,2,4,6,9,12], [1,2,3,7,10,13],[1,2,4,7,12,13],
    [1,2,4,6,10,11],[1,2,4,5,11,13],[1,2,4,8,11,13]
]
GroupB = [
    [1,1,2,3,8,13], [1,1,3,4,6,13], [1,2,2,4,6,13],
    [1,1,2,4,9,11], [1,1,3,5,8,10], [1,2,2,5,8,10],
    [1,1,2,4,8,12], [1,1,3,5,7,11], [1,2,2,5,7,11],
    [1,1,2,4,7,13], [1,1,3,5,6,12], [1,2,2,5,6,12],
    [1,1,2,5,9,10], [1,1,3,6,8,9],  [1,2,2,6,8,9],
    [1,1,2,5,8,11], [1,1,3,6,7,10], [1,2,2,6,7,10],
    [1,1,2,5,7,12], [1,2,2,3,9,11], [1,2,3,3,9,10],
    [1,1,2,5,6,13], [1,2,2,3,8,12], [1,2,3,3,8,11],
    [1,1,3,4,9,10], [1,2,2,3,7,13], [1,2,3,3,7,12],
    [1,1,3,4,8,11], [1,2,2,4,8,11], [1,2,3,4,9,9],
    [1,1,3,4,7,12], [1,2,2,4,7,12], [1,2,3,5,5,12],

    [1,2,3,6,6,10], [1,2,4,4,5,13], [1,2,4,5,5,13],
    [1,2,4,4,8,9],  [1,2,4,5,5,12], [1,2,4,5,9,9],
    [1,2,4,5,5,11], [1,1,2,4,9,13], [1,2,4,6,6,11],
    [1,2,4,6,6,9],  [1,1,2,5,10,11],[1,2,4,7,7,9],
    [1,1,2,4,9,12], [1,1,2,5,9,12], [1,1,2,5,10,12],
    [1,1,2,4,8,13], [1,1,2,5,8,13], [1,1,2,5,9,13],
    [1,1,2,5,9,11], [1,1,3,4,10,11],[1,1,3,4,10,12],
    [1,1,2,5,8,12], [1,1,3,4,9,12], [1,1,3,4,9,13],
    [1,1,2,5,7,13], [1,1,3,4,8,13], [1,1,3,5,10,11],
    [1,1,3,4,9,11], [1,1,3,5,9,11], [1,1,3,5,9,12],
    [1,1,3,4,8,12], [1,1,3,5,8,12], [1,1,3,5,8,13],
    [1,1,3,4,7,13], [1,1,3,5,7,13], [1,1,3,6,9,11],
    [1,1,3,5,9,10], [1,1,3,6,9,10], [1,1,3,6,8,12],
    [1,1,3,5,8,11], [1,1,3,6,8,11], [1,1,3,6,7,13],
    [1,1,3,5,7,12], [1,1,3,6,7,12], [1,2,2,4,9,13],
    [1,1,3,5,6,13], [1,2,2,3,9,13], [1,2,2,5,10,11],
    [1,1,3,6,8,10], [1,2,2,4,10,11],[1,2,2,5,9,12],
    [1,1,3,6,7,11], [1,2,2,4,9,12], [1,2,2,5,8,13],
    [1,2,2,3,9,12], [1,2,2,4,8,13], [1,2,2,6,9,11],
    [1,2,2,3,8,13], [1,2,2,5,9,11], [1,2,2,6,7,13],
    [1,2,2,4,9,11], [1,2,2,5,8,12], [1,2,3,3,10,12],
    [1,2,2,4,7,13], [1,2,2,5,7,13], [1,2,3,3,9,13],
    [1,2,2,5,9,10], [1,2,2,6,9,10], [1,2,3,5,10,10],
    [1,2,2,5,8,11], [1,2,2,6,8,11], [1,2,3,6,6,13],
    [1,2,2,5,7,12], [1,2,2,6,7,12], [1,2,3,7,7,11],
    [1,2,2,5,6,13], [1,2,3,3,10,11],[1,2,3,7,9,9],
    [1,2,2,6,10,11],[1,2,3,3,9,12], [1,2,4,4,9,11],
    [1,2,2,6,7,11], [1,2,3,3,8,13], [1,2,4,4,7,13],
    [1,2,3,3,9,11], [1,2,3,4,10,10],[1,2,4,6,9,9],
    [1,2,3,3,8,12], [1,2,3,6,6,12], [1,2,4,7,7,10],
    
    [1,1,3,6,8,13], [1,2,2,4,11,13],[1,2,4,7,7,13],
    [1,2,2,4,10,13],[1,2,2,5,11,12],[1,2,4,7,10,10],
    [1,2,2,5,10,12],[1,2,2,5,10,13],[1,2,4,8,8,11],
    [1,2,2,5,9,13], [1,2,2,6,9,13], [1,1,3,6,11,13],
    [1,2,2,6,9,12], [1,2,3,3,11,13],[1,2,2,6,11,13],
    [1,2,2,6,8,13], [1,2,3,5,11,11],[1,2,3,5,12,12],
    [1,2,3,3,10,13],[1,2,3,7,7,13], [1,2,4,4,11,13],
    [1,2,3,4,11,11],[1,2,3,7,10,10],[1,2,4,6,11,11],
    [1,2,3,6,10,10],[1,2,4,7,7,12], [1,1,3,6,12,13],
    [1,2,3,7,7,12], [1,2,4,8,9,9],  [1,2,2,6,12,13],
    [1,2,4,4,10,11],[1,1,3,5,11,13],[1,2,3,6,12,12],
    [1,2,4,4,9,12], [1,1,3,6,11,12],[1,2,4,4,12,13],
    [1,2,4,4,8,13], [1,1,3,6,10,13],[1,2,4,5,12,12],
    [1,2,4,6,6,13], [1,2,2,4,12,13],[1,2,4,7,11,11],
    [1,2,4,7,7,11], [1,2,2,5,11,13],[1,2,4,8,8,13],
    [1,2,4,7,9,0],  [1,2,2,6,11,12],[1,2,2,6,13,13],
    [1,2,4,8,8,9],  [1,2,2,6,10,13],[1,2,3,5,13,13],
    [1,1,3,5,11,12],[1,2,3,6,11,11],[1,2,4,8,11,11],
    [1,1,3,5,10,13],[1,2,4,4,11,12],[1,2,3,6,13,13],
    [1,1,3,6,10,12],[1,2,4,4,10,13],[1,2,4,7,12,12],
    [1,1,3,6,9,13], [1,2,4,5,11,11],[1,2,3,7,13,13]
]

def newPins():
  while 1:
   try:
    tb = []
    tb = [0] * 78 + [1] * 78 
    random.shuffle( tb )
    random.shuffle( tb )
    random.shuffle( tb )
    random.shuffle( tb )
    Pins = ""
    for i in range(131):
        if tb[i]:
            Pins += "1"
        else:
            Pins += "0"
    # --- verify that there are less than 6 pins in the same state in a row
    lg_wheels = [ 26, 25, 23, 21, 19, 17 ]
    start = 0
    for i in range(6):
        aRow = 0 ; aPinA = 1
        for j in range(lg_wheels[i]+6):
            k = (j % lg_wheels[i]) + start
            v =  Pins[k]
            if v == aPinA: aRow += 1 ; 
            else: aRow = 1; aPinA = v
            if aRow > 6:
                if DEBUG: print ">>>>",Pins[start:start+lg_wheels[i]]
                raise Error 
        start += lg_wheels[i]
    
    # --- verify
    if DEBUG: print Pins,
    Nb_actives = 0
    for i in range(131):
        if Pins[i] == "1": Nb_actives += 1
    percentage = float(Nb_actives) / 131.
    if DEBUG: print "% = ", percentage
    return Pins
   except:
    pass
#-----------------------------------------------------
def newLugs(c):
    Lugs = [0]*6
    while 1:
     try:
        # --- Select a set of six numbers from either the GroupA
        #     or the GroupB. 
        #     Sets of numbers selected from GroupB must not exceed
        #     10 per cent of the total sets selected
        Group = GroupA
        if random.random() > 0.9 : Group = GroupB
        Lugs = random.choice( Group )
        random.shuffle( Lugs )
        random.shuffle( Lugs )
        random.shuffle( Lugs )
        random.shuffle( Lugs )
        if DEBUG: print Lugs

        # --- calculate Overlaps
        lugs2 = list(Lugs)
        theSum = sum(Lugs)
        nbover = theSum - 27
        if DEBUG: print "Numbers of Overlaps: ", nbover
        if M1947 and nbover < 2:
            print "Too few overlaps (1947 rules)"
            raise Exception
        overlaps = { '1-2':0, '1-3':0, '1-4':0, '1-5':0, '1-6':0, '2-3':0, \
                     '2-4':0, '2-5':0, '2-6':0, '3-4':0, '3-5':0, '3-6':0, \
                     '4-5':0, '4-6':0, '5-6':0 }    
        overkeys = overlaps.keys()
        flag = 0
        for i in range( nbover ):
            flag2 = 0
            for j in range(100000):
                un_over = random.choice( overkeys )
                n1 =  int( un_over[0] ) -1
                n2 =  int( un_over[2] ) -1
                if lugs2[n1] > 0 and lugs2[n2] > 0 :
                    overlaps[ un_over ] += 1
                    if overlaps[ un_over ] > 4:
                        if DEBUG: 
                            print "Error: more than 4 overlaps between 2 numbers"
                        raise Exception
                    lugs2[n1] -= 1
                    lugs2[n2] -= 1
                    flag2 = 1
                    break
            if flag2 == 0:
                flag = 1
                break
        if flag == 1: 
            if DEBUG: print "Error bcl", Lugs, overlaps
            raise Exception
        if DEBUG: print overlaps
        for key in overlaps.keys():
            c.setOverByKey(key, overlaps[key])

        # --- combinaisons must yield all the numbers from 1 to 27
        valeurs = [0] * 28
        valeurs[0] = 1
        for v in range(64):
            ch = bin(64 + v )
            activesPins = []
            for j in range(6):
                activesPins.append( int( ch[3 + j] ) )
            shift = 0
            for j in range( 6 ):
                shift = shift + activesPins[j] * Lugs[j]
            o = overlaps
            shift = shift - o['1-2'] * activesPins[0] * activesPins[1]
            shift = shift - o['1-3'] * activesPins[0] * activesPins[2]
            shift = shift - o['1-4'] * activesPins[0] * activesPins[3]
            shift = shift - o['1-5'] * activesPins[0] * activesPins[4]
            shift = shift - o['1-6'] * activesPins[0] * activesPins[5]
            shift = shift - o['2-3'] * activesPins[1] * activesPins[2]
            shift = shift - o['2-4'] * activesPins[1] * activesPins[3]
            shift = shift - o['2-5'] * activesPins[1] * activesPins[4]
            shift = shift - o['2-6'] * activesPins[1] * activesPins[5]
            shift = shift - o['3-4'] * activesPins[2] * activesPins[3]
            shift = shift - o['3-5'] * activesPins[2] * activesPins[4]
            shift = shift - o['3-6'] * activesPins[2] * activesPins[5]      
            shift = shift - o['4-5'] * activesPins[3] * activesPins[4]
            shift = shift - o['4-6'] * activesPins[3] * activesPins[5]
            shift = shift - o['5-6'] * activesPins[4] * activesPins[5]
            valeurs[ shift ] = 1
        flag = 0
        for i in range(28):
            if valeurs[i] == 0: flag = 1
        if flag:
            if DEBUG: print "Error: not all values ",Lugs,valeurs,overlaps
            raise Exception        
        # --- return if all tests are good
        if DEBUG: print sorted(Lugs)
        return Lugs
     except:
        pass
#-----------------------------------------------------
def printKeyList(c):
    wheels = []
    wheels.append( "ABCDEFGHIJKLMNOPQRSTUVWXYZ" )
    wheels.append( "ABCDEFGHIJKLMNOPQRSTUVXYZ" )
    wheels.append( "ABCDEFGHIJKLMNOPQRSTUVX" )
    wheels.append( "ABCDEFGHIJKLMNOPQRSTU" )
    wheels.append( "ABCDEFGHIJKLMNOPQRS" )
    wheels.append( "ABCDEFGHIJKLMNOPQ" )
    for aWheel in range(6):
        ch = ""
        for aPin in range(len(wheels[aWheel])):
            value = c.getPins( aWheel, wheels[aWheel][aPin] )
            if value: ch += wheels[aWheel][aPin]
            else:     ch += "_"
        print ch
    print "Z"
    Lugs = c.getLugs()
    Lugs_ch = map(str,Lugs)
    print ":".join(Lugs_ch)
    over = c.getOver()
    overlaps = [ '1-2', '1-3', '1-4', '1-5', '1-6', '2-3', \
                 '2-4', '2-5', '2-6', '3-4', '3-5', '3-6', \
                 '4-5', '4-6', '5-6' ]
    nbLineOver = 0
    for i in range(len(over)):
        if int(over[i]) > 0: nbLineOver += 1
    print nbLineOver
    for i in range(len(over)):
        if int(over[i]) > 0:
            print "%s:%s" % (overlaps[i], over[i])
    print

def usage():
    print "Options:"
    print " -h          Help"
    print " -d          Debug"
    print " -m modele   1944, 1947 (by default, 1944)"
#=====================================================
DEBUG = False
M1947 = False
if __name__ == "__main__":
    try:
        opts, args = getopt.getopt(sys.argv[1:],
        "hdm:", ["help","debug","modele=" ])
    except getopt.GetoptError as err:
        # print help information and exit:
        print sys.argv[0],": ", str(err) # option -a not recognized"
        sys.exit(2)
    for o, a in opts:
        if   o in ("-d", "--debug"):
            DEBUG = True
        elif o in ("-h", "--help"):
            usage()
            sys.exit()
        elif o in ("-m", "--modele"):
            if a == "1947": M1947 = True
        else:
            usage()
            sys.exit()

    # --- create a cipher machine
    c = Hagelin('Z',0)
    
    # --- generate Pins
    Pins = newPins()
    c.setAllPinsAllW( Pins )

    # --- generate Lugs
    Lugs = newLugs(c)
    c.setLugs(Lugs)

    # --- print Internal Key
    printKeyList(c)

