# printkey.py 
# print a key-list from a file which contains the internal setting
# of a M-209.

import sys
from m209 import *
import string

#============================================
def printKey( c ):
    lesPins = []
    for i in range( 6):
        lesPins.append( c.getPinsOfAWheel( i ) )
    tailleRoues = [ 26, 25, 23, 21, 19, 17 ]

    chWheels = []
    for i in range(27):
        ch = "     "
        for j in range(6):
            if i < tailleRoues[j]:
                ch +=  lesPins[j][i]
            else:
                ch +=  " " 
            ch += "  " 
        chWheels.append( ch )

    Lugs = c.getLugs()
    Over = c.getOver()
    overlaps = [ '1-2', '1-3', '1-4', '1-5', '1-6', '2-3', \
                 '2-4', '2-5', '2-6', '3-4', '3-5', '3-6', \
                 '4-5', '4-6', '5-6' ]
    Lugs2= list( Lugs )
    for i in range(len(Over)):
        if Over[i] > 0:
            #print x, Over[x],
            n1 = int( overlaps[i][0] )
            n2 = int( overlaps[i][2] )
            Lugs2[ n1 - 1 ] -= Over[i]
            Lugs2[ n2 - 1 ] -= Over[i]
            #print n1, n2
    chLugs = []
    n = 1
    for i in range(len(Over)):
        for j in range( Over[i] ):
            x = overlaps[i]
            chLugs.append( "%02d  %s" % (n, x) )
            n += 1
    for i in range(6):
        if Lugs2[i] == 0: continue
        for j in range(Lugs2[i]):
            if i < 3:
                chLugs.append( "%02d  %1d-%1d" % ( n, i+1, 0) )
            else:
                chLugs.append( "%02d  %1d-%1d" % ( n, 0, i+1) )
            n += 1
    crypto = ""
    for i in range(26):
        if (i%5) == 0 and i != 0 : crypto += " "
        crypto += c.cipher("A")

    chResult = ""
    chResult += "-------------------------------" + '\n'
    chResult += "NR  LUGS    1  2  3  4  5  6" + '\n'
    chResult += "-------------------------------" + '\n'
    for i in range(27):
        chResult += chLugs[i] + chWheels[i] + '\n'
    chResult += "-------------------------------" + '\n'
    chResult += "26 letters Check:" + '\n'
    chResult += crypto + '\n'
    chResult += "-------------------------------" + '\n'
    return chResult
#===========================================================
if __name__ == "__main__":
    if len(sys.argv) < 2:
        print "Syntax: python printkey.py key_file "
        print "       don't write the extension (.key ou .m209key)"
        sys.exit(1)
    c = Hagelin( "Z", 0)
    KEYINTERN= sys.argv[1]
    restore(c, KEYINTERN)
    KEYEXTERN= "AAAAAA"
    c.setExternalKey(KEYEXTERN)
    print printKey( c )

